/* Copyright (C) 2000-2002 Lavtech.com corp. All rights reserved.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#include "udm_config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>

#include "udm_common.h"
#include "udm_utils.h"
#include "udm_id3.h"


char *get_id3_tag(UDM_DOCUMENT *Doc){
	size_t		len;
	char		*ch;
	char		*buf_out=NULL;
	char		*buf_in=Doc->Buf.content;
	char		blank[2]="";
	int		tagcount=0;
	unsigned char	frame_size;
	char		*artist=NULL;
	char		*album=NULL;
	char		*songname=NULL;
	int		hd;
	size_t		cont_len;
	size_t		hdr_len;
	
	hdr_len=Doc->Buf.content-Doc->Buf.buf;
	if(hdr_len>Doc->Buf.size)return NULL;
	cont_len=Doc->Buf.size-hdr_len;
	
	hd=((unsigned char)(buf_in[0])+256*(unsigned char)(buf_in[1])) & 0xf0ff;
	
	if(hd == 0xf0ff){
		/* MP3 tags are in footer */
		/* Download it again with */
		/* "Range: bytes=-128"    */
		Doc->is_mp3=1;
		return NULL;
        }
	
        if (!strncmp(buf_in, "RIFF", 4)){
        	Doc->is_mp3=1;
		return NULL;
	}
	
        if (!strncmp(buf_in, "ID3", 3)){
		
		Doc->is_mp3=1;
		
		/* 
			id3 header v2.3.0 http://www.id3.org
			
			ID3	3
			version	1+1
    			flag	1
			size	4
		*/
		
		ch = buf_in;
		if ( *(ch+6) == 'b'){
			/*
				extened header:
				size	4
				flag	2
				size of pagging 4
			*/
			
			ch +=20;
		}else{
			ch +=10;
		}
		
		while(1){
			/*
				frame header:
				frame id 4
				size	4
				flags	2 
			*/
			
			frame_size = (unsigned char)*(ch+7);
			len = frame_size>cont_len?cont_len:frame_size;
			
			if (!strncmp(ch , "TPE1", 4)){
				ch +=10;
				artist = malloc(len+1);
				snprintf(artist, len, "%s", ch+1);
				artist[len]='\0';
				UdmRTrim(artist," ");
				if (++tagcount == 3)
					break;
			}else if(!strncmp(ch , "TALB", 4)){
				ch +=10;
				album = malloc(len+1);
				snprintf(album, len, "%s", ch+1);
				album[len]='\0';
				UdmRTrim(album," ");
				if (++tagcount == 3)
					break;
			}else if(!strncmp(ch , "TIT2", 4) ){
				ch +=10;
				songname = malloc(len+1);
				snprintf(songname, len, "%s", ch+1);
				songname[len]='\0';
				UdmRTrim(songname," ");
				if (++tagcount == 3)
					break;
			}else if ((ch - buf_in+frame_size) <cont_len){
				ch +=10;
			}else{
				break;
			}
			ch +=frame_size;
		}
		if (!artist)
			artist=strdup(blank);
		if (!album)
			album=strdup(blank);
		if (!songname)
			songname=strdup(blank);
		
		buf_out = malloc(cont_len+200);
		snprintf(buf_out,cont_len+200,"<title>%s</title><meta name=description content=\"%s\"><meta name=keywords content=\"%s\"><body>%s %s %s</body>",
			songname,artist,album,artist,album,songname);
		buf_out[cont_len+200-1]='\0';
		
		UDM_FREE(artist);
		UDM_FREE(album);
		UDM_FREE(songname);
		
		return buf_out;
        }
	
	
        if (!strncmp(buf_in, "TAG", 3)){
		char year[5]="";
		
		Doc->is_mp3=1;
		
		/* Artist */
		artist = malloc(31);
		snprintf(artist, 31, "%s", buf_in+33);
		artist[30]='\0';
		UdmRTrim(artist, " ");
		
		/* Album */
		album = malloc(31);
		snprintf(album, 31, "%s", buf_in+63);
		album[30]='\0';
		UdmRTrim(album, " ");
		
		/* Songname */
		songname = malloc(31);
		snprintf(songname, 31, "%s", buf_in+3);
		songname[30]='\0';
		UdmRTrim(songname, " ");
		
		/*Year*/
                snprintf(year, 5, "%s", buf_in+93);
                year[4]='\0';
                UdmRTrim(songname, " ");
                
		if (!artist)
			artist=strdup(blank);
		if (!album)
			album=strdup(blank);
		if (!songname)
			songname=strdup(blank);
		
		buf_out = malloc(cont_len+200);
		snprintf(buf_out,cont_len+200,"<title>%s</title>\n<meta name=description content=\"%s\">\n<meta name=keywords content=\"%s %s\">\n<body>%s %s %s %s</body>",
			songname,artist,album,year,artist,album,year,songname);
		buf_out[cont_len+200-1]='\0';
		UDM_FREE(artist);
		UDM_FREE(album);
		UDM_FREE(songname);
		
		return buf_out;
	}
	
	return NULL;
}
